from srunner.scenariomanager.carla_data_provider import CarlaDataProvider
from comm.channel import Channel, LockBuffer
from comm.message_types import Beacon, Language, Representation, Topic
from comm.transceiver import VehicleState
import comm.comm_config as comm_config

class CentralReceiver:
    """
    CentralReceiver is a class that receives messages from all the nodes in the network.
    """
    def __init__(self,
                 channels=[Topic.BEACON, Topic.LANGUAGE, Topic.REPRESENTATION],
                 ):
        self.id = 'central_receiver'
        self.world = CarlaDataProvider.get_world()
        self.state = VehicleState()
        self.startFrameID = -1
        self.ProcessThread = None

        """Comm"""
        self.beacon_channel = Channel(self, Topic.BEACON)
        self.lang_channel = Channel(self, Topic.LANGUAGE)
        self.repr_channel = Channel(self, Topic.REPRESENTATION)

    def destroy(self):
        self.beacon_channel.destroy()
        self.lang_channel.destroy()
        if self.ProcessThread is not None:
            self.ProcessThread.join()

    def get_lang_data(self):
        """
        Get language data from the channel
        """
        message_data = {}
        for peerId, buffer in self.lang_channel.buffer.items():
            message = buffer.get_content(comm_config.MaxDataAge)
            if message is not None:
                message_data[peerId] = message
        return message_data

    def get_repr_data(self):
        """
        Get representation data from the channel
        """
        message_data = {}
        for peerId, buffer in self.repr_channel.buffer.items():
            message_data[peerId] = buffer.get_content()
        return message_data
